function test_suite = test_symvar %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
vars = symvar(polysym.empty);
assertTrue(isempty(vars))

function testDefault
vars = symvar(polysym);
assertTrue(isempty(vars))

function testOneVar
x = polysym('x');
vars = symvar(x);
assertEqual(vars,x)

function testMultipleVars
polysyms('x','y','z')
p = x^2*y^2+y^2*z^2+z^2*x^2;
vars = symvar(p);
assertEqual(vars,[x y z])

function testArray
p = polysym('M',2);
vars = p.symvar;
assertEqual(vars,unique(p).')

function testLongerName
polysyms('do','the','twist')
vars = symvar([twist twist do the]);
assertEqual(vars,[do the twist])

function testNumber
polysyms('x')
vars = symvar(x*(1+1i));
assertEqual(vars,x)

function testExceptions
p = polysym('2.3*exp(pi*x) + sin(y) + cos(z) + e');
vars = p.symvar;
assertEqual(vars,polysym({'x','y','z'}))

function testNumberWithExponential
p = polysym('1e10');
vars = p.symvar;
assertTrue(isempty(vars))

